package com.hero.objects.powers;

import java.util.ArrayList;
import java.util.Collections;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class Shapeshift extends SenseAffectingPower {

	private static String xmlID = "SHAPESHIFT";

	public Shapeshift(Element root) {
		super(root, Shapeshift.xmlID);
	}

	public ArrayList<Adder> getAssignedAdders() {
		if (!HeroDesigner.getActiveTemplate().is6E()) return super.getAssignedAdders();
		
		long current = System.currentTimeMillis();
		ArrayList<Adder> ret = super.getAssignedAdders();
		for (int i=0; i<ret.size(); i++) {
			Adder ad = ret.get(i);
			if (ad.getXMLID().indexOf("SIGHT")>=0) {
				ad.setBaseCost(targetingCost);
			} else if (ad.getXMLID().indexOf("HEARING")>=0) {
				ad.setBaseCost(nontargetingCost);
			} else if (ad.getXMLID().indexOf("TOUCH")>=0) {
				ad.setBaseCost(nontargetingCost);
			} else if (ad.getXMLID().indexOf("MENTAL")>=0) {
				ad.setBaseCost(targetingGroupCost);
			} else if (ad.getXMLID().indexOf("RADIO")>=0) {
				ad.setBaseCost(targetingGroupCost);
			} else if (ad.getXMLID().indexOf("SMELL")>=0) {
				ad.setBaseCost(targetingGroupCost);
			} else if (ad.getXMLID().endsWith("GROUP")){
				ad.setBaseCost(nontargetingGroupCost);
			}
		}
		return ret;
	}

	public ArrayList<Adder> getAvailableAdders() {
		if (!HeroDesigner.getActiveTemplate().is6E()) return super.getAvailableAdders();
		ArrayList<Adder> ret = (ArrayList<Adder>) super.getAvailableAdders();
		for (int i=0; i<ret.size(); i++) {
			Adder ad = ret.get(i);
			if (ad.getXMLID().indexOf("SIGHT")>=0) {
				ad.setBaseCost(targetingCost);
			} else if (ad.getXMLID().indexOf("HEARING")>=0) {
				ad.setBaseCost(nontargetingCost);
			} else if (ad.getXMLID().indexOf("TOUCH")>=0) {
				ad.setBaseCost(nontargetingCost);
			} else if (ad.getXMLID().indexOf("MENTAL")>=0) {
				ad.setBaseCost(targetingGroupCost);
			} else if (ad.getXMLID().indexOf("RADIO")>=0) {
				ad.setBaseCost(targetingGroupCost);
			} else if (ad.getXMLID().indexOf("SMELL")>=0) {
				ad.setBaseCost(targetingGroupCost);
			} else if (ad.getXMLID().endsWith("GROUP")){
				ad.setBaseCost(nontargetingGroupCost);
			}
		}
		return ret;
	}

	@Override
	public String getColumn2Output() {
		String ret = getAlias() + " " + getDamageDisplay();
		if (getName().trim().length() > 0) {
			ret = "<i>" + getName() + ":</i>  " + ret;
		}
		if ((getInput() != null) && (getInput().trim().length() > 0)) {
			ret += ":  " + getInput();
		}
		String shapes = "";
		ArrayList<String> groups = new ArrayList<String>();
		ArrayList<String> senses = new ArrayList<String>();
		ArrayList<Sense> allSenses = Sense.getAllSenses();
		String group = "[Unknown]";
		if (getSelectedOption() != null) {
			group = getSelectedOption().getAlias();
		}
		if (group.toUpperCase().indexOf("GROUP") > 0) {
			group = group.substring(0, group.toUpperCase().indexOf("GROUP"))
					.trim();
		}
		groups.add(group);
		for (Adder ad : getAssignedAdders()) {
			if (ad.getXMLID().equals("SHAPES")
					&& (ad.getSelectedOption() != null)) {
				ad.setDisplayInString(false);
				shapes = ad.getSelectedOption().getAlias();
			}
			if (ad.getXMLID().equals("ADDITIONAL_GROUP")) {
				ad.setDisplayInString(false);
				group = ad.getSelectedOption().getAlias();
				if (group.toUpperCase().indexOf("GROUP") > 0) {
					group = group.substring(0,
							group.toUpperCase().indexOf("GROUP")).trim();
				}
				groups.add(group);
			} else if (ad.getXMLID().endsWith("GROUP")) {
				ad.setDisplayInString(false);
				group = ad.getAlias();
				if (group.toUpperCase().indexOf("GROUP") > 0) {
					group = group.substring(0,
							group.toUpperCase().indexOf("GROUP")).trim();
				}
				groups.add(group);
			} else if (ad.getXMLID().equals("ADDITIONAL_SENSE")) {
				ad.setDisplayInString(false);
				String sense = ad.getSelectedOption().getAlias();
				senses.add(sense);
			} else if (GenericObject.findObjectByID(allSenses, ad.getXMLID()) != null) {
				ad.setDisplayInString(false);
				String sense = ad.getAlias();
				senses.add(sense);
			}
		}
		ret += " (";
		for (int i = 0; i < groups.size(); i++) {
			if ((i > 0) && (i < groups.size() - 1)) {
				ret += ", ";
			} else if ((i == groups.size() - 1) && (i > 0)) {
				ret += " and ";
			}
			ret += groups.get(i);
		}
		if (groups.size() > 1) {
			ret += " Groups";
		} else {
			ret += " Group";
		}
		for (int i = 0; i < senses.size(); i++) {
			if (i < senses.size() - 1) {
				ret += ", ";
			} else {
				ret += " and ";
			}
			ret += senses.get(i);
		}
		if (shapes.trim().length() > 0) {
			ret += ", " + shapes;
		}
		ret += ")";
		String adderString = getAdderString();
		if (adderString.trim().length() > 0) {
			ret += ", " + adderString;
		}
		ret += getModifierString();
		if ((getEndUsage() > 0)
				&& (GenericObject.findObjectByID(HeroDesigner.getActiveHero()
						.getPowers(), "ENDURANCERESERVE") != null)
				&& (GenericObject.findObjectByID(getAllAssignedModifiers(),
						"ENDRESERVEOREND") == null)
				&& !HeroDesigner.getInstance().getPrefs().useWG()) {
			if (getUseENDReserve()) {
				ret += " (uses END Reserve)";
			} else {
				ret += " (uses Personal END)";
			}
		}
		return ret;
	}

	@Override
	public String getDamageDisplay() {
		return "";
	}
	
	public ArrayList<Adder> getOptions() {
		if (!HeroDesigner.getActiveTemplate().is6E()) {
			return super.getOptions();
		}
		if ((optionsLastCall > 0)
				&& (optionsLastCall >= GenericObject.lastEdit)
				&& (optionsSaver != null)) {
			return optionsSaver;
		}
		optionsLastCall = System.currentTimeMillis();
		ArrayList<Adder> ret = new ArrayList<Adder>();
		if ((targetingCost >= 0) || (nontargetingCost >= 0)) {
			ArrayList<SenseGroup> allGroups = SenseGroup.getAllGroups();
			for (SenseGroup group : allGroups) {
				if (group.getXMLID().equals("UNUSUALGROUP")) {
					continue;
				}
				if (group.getXMLID().equals("NOGROUP")) {
					continue;
				}
				if (group.getXMLID().equals("SIGHTGROUP")) {
					Adder ad = new Adder(group);
					if (levelValue <= 0) {
						ad.setBaseCost(targetingCost);
						ad.setLevelCost(-1);
						ad.setLevelValue(-1);
					} else {
						ad.setBaseCost(0);
						ad.setLevelCost(targetingCost);
						ad.setLevelValue(levelValue);
					}
					ret.add(ad);
				} else if (group.getXMLID().equals("HEARINGGROUP")) {
					Adder ad = new Adder(group);
					if (levelValue <= 0) {
						ad.setBaseCost(nontargetingCost);
						ad.setLevelCost(-1);
						ad.setLevelValue(-1);
					} else {
						ad.setBaseCost(0);
						ad.setLevelCost(nontargetingCost);
						ad.setLevelValue(levelValue);
					}
					ret.add(ad);
				} else if (group.getXMLID().equals("TOUCHGROUP")) {
					Adder ad = new Adder(group);
					if (levelValue <= 0) {
						ad.setBaseCost(nontargetingCost);
						ad.setLevelCost(-1);
						ad.setLevelValue(-1);
					} else {
						ad.setBaseCost(0);
						ad.setLevelCost(nontargetingCost);
						ad.setLevelValue(levelValue);
					}
					ret.add(ad);
				} else if (group.getXMLID().equals("SMELLGROUP")) {
					Adder ad = new Adder(group);
					if (levelValue <= 0) {
						ad.setBaseCost(targetingGroupCost);
						ad.setLevelCost(-1);
						ad.setLevelValue(-1);
					} else {
						ad.setBaseCost(0);
						ad.setLevelCost(targetingGroupCost);
						ad.setLevelValue(levelValue);
					}
					ret.add(ad);
				} else if (group.getXMLID().equals("MENTALGROUP")) {
					Adder ad = new Adder(group);
					if (levelValue <= 0) {
						ad.setBaseCost(targetingGroupCost);
						ad.setLevelCost(-1);
						ad.setLevelValue(-1);
					} else {
						ad.setBaseCost(0);
						ad.setLevelCost(targetingGroupCost);
						ad.setLevelValue(levelValue);
					}
					ret.add(ad);
				} else if (group.getXMLID().equals("RADIOGROUP")) {
					Adder ad = new Adder(group);
					if (levelValue <= 0) {
						ad.setBaseCost(targetingGroupCost);
						ad.setLevelCost(-1);
						ad.setLevelValue(-1);
					} else {
						ad.setBaseCost(0);
						ad.setLevelCost(targetingGroupCost);
						ad.setLevelValue(levelValue);
					}
					ret.add(ad);
				}
				
			}
		}
		if (ret.size() == 0) {
			oldMethod = true;
			optionsSaver = super.getOptions();
			return super.getOptions();
		}
		Collections.sort(ret);
		optionsSaver = ret;
		return ret;
	}
}